/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import com.ibm.hsc.access.api.AcaUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Hashtable;
import java.util.Locale;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class HscPasswordMgr {
    public static final String noUser = "unknownuser";
    public static final String noKey = "NO_KEY_SET";
    public static final String hscUser = "hscroot";
    private static final String flagFile = "/var/hsc/log/.old_methods_off";
    private static boolean enableOldMethods = true;

    public static synchronized String getHscUser() {
        String string = AcaUtils.getUsername();
        if (string == null) {
            return noUser;
        }
        return string;
    }

    public static synchronized String getCredentialKey(String string) {
        if (string == null || noUser.equalsIgnoreCase(string)) {
            return noKey;
        }
        String string2 = AcaUtils.getPwdkeyByName((String)string);
        if (string2 == null) {
            System.err.println("HscPwdMgr.getCredentialKey Error: for user (" + string + "), the Credentail-key is NULL.");
            string2 = noKey;
        }
        return string2;
    }

    public static String getPassword(String string) {
        if (!enableOldMethods) {
            return noKey;
        }
        Hashtable hashtable = new Hashtable();
        FileInputStream fileInputStream = null;
        ObjectInputStream objectInputStream = null;
        String string2 = null;
        Object var5_5 = null;
        boolean bl = false;
        Locale locale = Locale.getDefault();
        Locale.setDefault(Locale.US);
        try {
            fileInputStream = new FileInputStream("/opt/hsc/data/npwd");
        }
        catch (FileNotFoundException fileNotFoundException) {
            HscPasswordMgr.migratePassword(string, null);
            try {
                fileInputStream = new FileInputStream("/opt/hsc/data/npwd");
            }
            catch (FileNotFoundException fileNotFoundException2) {
                Locale.setDefault(locale);
                return null;
            }
        }
        try {
            objectInputStream = new ObjectInputStream(fileInputStream);
            hashtable = (Hashtable)objectInputStream.readObject();
        }
        catch (IOException iOException) {
            System.out.println("IOException");
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("ClassNotFoundException");
            bl = true;
        }
        try {
            if (objectInputStream != null) {
                objectInputStream.close();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        catch (IOException iOException) {
            System.out.println("IOException closing stream");
        }
        if (!bl) {
            int[] nArray = (int[])hashtable.get(string);
            string2 = HscPasswordMgr.hscDecode(nArray);
        }
        Locale.setDefault(locale);
        return string2;
    }

    public static int setPassword(String string, String string2) {
        if (!enableOldMethods) {
            return 0;
        }
        FileOutputStream fileOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        int[] nArray = null;
        Hashtable<String, int[]> hashtable = new Hashtable<String, int[]>();
        Locale locale = Locale.getDefault();
        Locale.setDefault(Locale.US);
        int n = 0;
        nArray = HscPasswordMgr.hscEncode(string2);
        hashtable.put(string, nArray);
        try {
            fileOutputStream = new FileOutputStream("/opt/hsc/data/npwd");
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("FileNotFoundException");
            Locale.setDefault(locale);
            return -1;
        }
        try {
            objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(hashtable);
            objectOutputStream.flush();
        }
        catch (IOException iOException) {
            System.out.println("IOException");
            n = -1;
        }
        try {
            if (objectOutputStream != null) {
                objectOutputStream.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        catch (IOException iOException) {
            System.out.println("IOException closing stream");
        }
        Locale.setDefault(locale);
        return n;
    }

    private static int[] hscEncode(String string) {
        int[] nArray = null;
        int n = 0;
        char c = '\u0000';
        if (string == null) {
            return null;
        }
        nArray = new int[string.length()];
        for (int i = 0; i < nArray.length; ++i) {
            c = string.charAt(i);
            n = 0;
            n |= (c & '\u0001') << 5;
            n |= (c & 2) << 6;
            n |= (c & 4) >>> 1;
            n |= (c & 8) << 9;
            n |= (c & 0x10) << 10;
            n |= (c & 0x20) >>> 3;
            n |= (c & 0x40) << 3;
            n |= (c & 0x80) << 6;
            n |= (c & 0x100) << 2;
            n |= (c & 0x200) << 6;
            n |= (c & 0x400) >>> 7;
            n |= (c & 0x800) >>> 5;
            n |= (c & 0x1000) >>> 12;
            n |= (c & 0x2000) >>> 9;
            n |= (c & 0x4000) >>> 6;
            nArray[i] = n |= (c & 0x8000) >>> 4;
        }
        return nArray;
    }

    private static void migratePassword(String string, String string2) {
        Hashtable hashtable = new Hashtable();
        FileInputStream fileInputStream = null;
        ObjectInputStream objectInputStream = null;
        String string3 = null;
        Locale locale = Locale.getDefault();
        Locale.setDefault(Locale.US);
        if (string2 == null) {
            String string4 = null;
            try {
                fileInputStream = new FileInputStream("/opt/hsc/data/passwords");
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("FileNotFoundException");
                Locale.setDefault(locale);
                return;
            }
            try {
                objectInputStream = new ObjectInputStream(fileInputStream);
                hashtable = (Hashtable)objectInputStream.readObject();
                objectInputStream.close();
                objectInputStream = null;
                fileInputStream.close();
                fileInputStream = null;
            }
            catch (IOException iOException) {
                System.out.println("IOException");
                Locale.setDefault(locale);
                try {
                    if (objectInputStream != null) {
                        objectInputStream.close();
                    }
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("ClassNotFoundException");
                Locale.setDefault(locale);
                try {
                    if (objectInputStream != null) {
                        objectInputStream.close();
                    }
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            string4 = (String)hashtable.get(string);
            try {
                string3 = HscPasswordMgr.hscCrypt(string4, false);
            }
            catch (GeneralSecurityException generalSecurityException) {
                System.out.println("GeneralSecurityException");
                Locale.setDefault(locale);
                return;
            }
        }
        string3 = string2;
        HscPasswordMgr.hscEncode(string3);
        HscPasswordMgr.setPassword(string, string3);
        Locale.setDefault(locale);
    }

    private static String hscDecode(int[] nArray) {
        StringBuffer stringBuffer = null;
        int n = 0;
        int n2 = 0;
        if (nArray == null) {
            return null;
        }
        stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            n2 = nArray[i];
            n = 0;
            n |= (n2 & 1) << 12;
            n |= (n2 & 2) << 1;
            n |= (n2 & 4) << 3;
            n |= (n2 & 8) << 7;
            n |= (n2 & 0x10) << 9;
            n |= (n2 & 0x20) >>> 5;
            n |= (n2 & 0x40) << 5;
            n |= (n2 & 0x80) >>> 6;
            n |= (n2 & 0x100) << 6;
            n |= (n2 & 0x200) >>> 3;
            n |= (n2 & 0x400) >>> 2;
            n |= (n2 & 0x800) << 4;
            n |= (n2 & 0x1000) >>> 9;
            n |= (n2 & 0x2000) >>> 6;
            n |= (n2 & 0x4000) >>> 10;
            stringBuffer.append((char)(n |= (n2 & 0x8000) >>> 6));
        }
        return stringBuffer.toString();
    }

    private static String hscCrypt(String string, boolean bl) throws GeneralSecurityException {
        SecretKey secretKey = null;
        Cipher cipher = null;
        String string2 = null;
        byte[] byArray = new byte[]{-72, 51, -30, 66, 79, 70, 25, 119};
        char[] cArray = new char[]{'a', 'r', 'k', 's', 'u', 'e', '&', 'm', 'e'};
        int n = 2;
        PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(byArray, n);
        PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
        secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
        cipher = Cipher.getInstance("PBEWithMD5AndDES");
        if (bl) {
            cipher.init(1, (Key)secretKey, pBEParameterSpec);
        } else {
            cipher.init(2, (Key)secretKey, pBEParameterSpec);
        }
        byte[] byArray2 = null;
        try {
            byArray2 = string.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray2 = string.getBytes();
        }
        string2 = new String(cipher.doFinal(byArray2));
        return string2;
    }

    public static void main(String[] stringArray) {
        Hashtable hashtable = new Hashtable();
        FileInputStream fileInputStream = null;
        FileInputStream fileInputStream2 = null;
        ObjectInputStream objectInputStream = null;
        String string = null;
        String string2 = null;
        Object var7_7 = null;
        if (stringArray.length < 1) {
            return;
        }
        String string3 = stringArray[0];
        if (!string3.equals(hscUser)) {
            return;
        }
        Locale locale = Locale.getDefault();
        Locale.setDefault(Locale.US);
        try {
            fileInputStream = new FileInputStream("/opt/hsc/data/npwd");
        }
        catch (FileNotFoundException fileNotFoundException) {
            HscPasswordMgr.migratePassword(string3, null);
            return;
        }
        try {
            fileInputStream2 = new FileInputStream("/opt/hsc/data/passwords");
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        try {
            objectInputStream = new ObjectInputStream(fileInputStream2);
            hashtable = (Hashtable)objectInputStream.readObject();
            objectInputStream.close();
            objectInputStream = null;
            fileInputStream2.close();
            fileInputStream2 = null;
        }
        catch (IOException iOException) {
            System.out.println("IOException");
            Locale.setDefault(locale);
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
                if (fileInputStream2 != null) {
                    fileInputStream2.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("ClassNotFoundException");
            Locale.setDefault(locale);
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
                if (fileInputStream2 != null) {
                    fileInputStream2.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        String string4 = (String)hashtable.get(string3);
        try {
            string = HscPasswordMgr.hscCrypt(string4, false);
        }
        catch (GeneralSecurityException generalSecurityException) {
            System.out.println("GeneralSecurityException");
            Locale.setDefault(locale);
            return;
        }
        try {
            objectInputStream = new ObjectInputStream(fileInputStream);
            hashtable = (Hashtable)objectInputStream.readObject();
            objectInputStream.close();
            objectInputStream = null;
            fileInputStream.close();
            fileInputStream = null;
        }
        catch (IOException iOException) {
            Locale.setDefault(locale);
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("ClassNotFoundException");
            Locale.setDefault(locale);
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        int[] nArray = (int[])hashtable.get(string3);
        string2 = HscPasswordMgr.hscDecode(nArray);
        if (!string2.equals(string)) {
            HscPasswordMgr.migratePassword(string3, string);
        }
        Locale.setDefault(locale);
    }

    static {
        if (new File(flagFile).exists()) {
            enableOldMethods = false;
        }
    }
}

